--update DS database with configurations.
use $(varBMS_DS)

BEGIN TRAN

update CT
SET CT.SOURCE_DB = NBD.VALUE,
	CT.LINKED_SERVER_NAME = '$(varNewServer)'
from [dbo].[ConfigTable] CT
inner join dbo.ufn_Split(N'$(varOldDBs)', ',') OBD on CT.SOURCE_DB = OBD.VALUE
inner join dbo.ufn_Split(N'$(varNewDBs)', ',') NBD on OBD.ID = NBD.ID

COMMIT TRAN

--update reference to DS database in the DW database
USE $(varBMS_DW)

BEGIN TRAN

EXEC sp_updateextendedproperty
     @name  = N'SourceDataBase',
     @value = N'$(varBMS_DS)'

COMMIT TRAN

--update subscriptions in the authz database
use $(varBMS_AUTHZ)

BEGIN TRAN

UPDATE [wsev].[SUBSCRIPTIONS]
SET 
SUBSCRIPTION_MANAGER_ENDPOINT = REPLACE(SUBSCRIPTION_MANAGER_ENDPOINT, '$(varOldServicesEndpoint)', '$(varNewServicesEndpoint)'),
DELIVERY_TO = REPLACE(DELIVERY_TO, '$(varOldServicesEndpoint)', '$(varNewServicesEndpoint)')

COMMIT TRAN